/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.core.breakpoints;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.ccdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.ccdt.debug.core.jsdi.ScriptReference;
import org.ccdt.debug.core.jsdi.event.BreakpointEvent;
import org.ccdt.debug.core.jsdi.event.Event;
import org.ccdt.debug.core.jsdi.event.EventSet;
import org.ccdt.debug.core.jsdi.event.ScriptLoadEvent;
import org.ccdt.debug.core.jsdi.request.BreakpointRequest;
import org.ccdt.debug.core.jsdi.request.EventRequest;
import org.ccdt.debug.core.jsdi.request.ScriptLoadRequest;
import org.ccdt.debug.internal.core.JavaScriptDebugPlugin;
import org.ccdt.debug.internal.core.breakpoints.JavaScriptBreakpoint$1;
import org.ccdt.debug.internal.core.breakpoints.JavaScriptBreakpoint$2;
import org.ccdt.debug.internal.core.model.IJavaScriptEventListener;
import org.ccdt.debug.internal.core.model.JavaScriptDebugTarget;
import org.ccdt.debug.internal.core.model.JavaScriptThread;
import org.ccdt.debug.internal.core.model.Script;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;

public abstract class JavaScriptBreakpoint
extends Breakpoint
implements IJavaScriptBreakpoint,
IJavaScriptEventListener {
    public static final String INSTALL_COUNT = "org.ccdt.debug.core.install_count";
    private HashSet q = null;
    private HashMap r = new HashMap(4);

    public void setMarker(IMarker iMarker) throws CoreException {
        super.setMarker(iMarker);
        this.setAttribute(INSTALL_COUNT, 0);
    }

    protected void setAttribute(String string, boolean bl) throws CoreException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        JavaScriptBreakpoint$1 javaScriptBreakpoint$1 = new JavaScriptBreakpoint$1(this, string, bl);
        iWorkspace.run((IWorkspaceRunnable)javaScriptBreakpoint$1, this.getMarkerRule(), 1, null);
    }

    protected void setAttribute(String string, Object object) throws CoreException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        JavaScriptBreakpoint$2 javaScriptBreakpoint$2 = new JavaScriptBreakpoint$2(this, string, object);
        iWorkspace.run((IWorkspaceRunnable)javaScriptBreakpoint$2, this.getMarkerRule(), 1, null);
    }

    protected void register(boolean bl) throws CoreException {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null && bl) {
            debugPlugin.getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    public String getModelIdentifier() {
        return "org.ccdt.debug.model";
    }

    public boolean shouldSkipBreakpoint() throws CoreException {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        return debugPlugin != null && this.isRegistered() && !debugPlugin.getBreakpointManager().isEnabled();
    }

    public void addToTarget(JavaScriptDebugTarget javaScriptDebugTarget) throws CoreException {
        if (javaScriptDebugTarget.isTerminated() || this.shouldSkipBreakpoint()) {
            return;
        }
        ScriptLoadRequest scriptLoadRequest = javaScriptDebugTarget.getEventRequestManager().createScriptLoadRequest();
        scriptLoadRequest.setEnabled(this.isEnabled());
        this.registerRequest(javaScriptDebugTarget, scriptLoadRequest);
        String string = this.getScriptPath();
        if (string == null) {
            return;
        }
        try {
            List list = javaScriptDebugTarget.underlyingScripts(Script.resolveName(URIUtil.fromString((String)string)));
            boolean bl = true;
            for (ScriptReference scriptReference : list) {
                if (!JavaScriptDebugPlugin.getResolutionManager().matches(scriptReference, (IPath)new Path(this.getScriptPath()))) continue;
                bl &= this.createRequest(javaScriptDebugTarget, scriptReference);
            }
            if (bl) {
                if (this.q == null) {
                    this.q = new HashSet();
                }
                this.q.add(javaScriptDebugTarget);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            JavaScriptDebugPlugin.log(uRISyntaxException);
        }
    }

    protected abstract boolean createRequest(JavaScriptDebugTarget var1, ScriptReference var2) throws CoreException;

    protected void configureRequest(BreakpointRequest breakpointRequest) throws CoreException {
        breakpointRequest.addHitCountFilter(this.getHitCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromTarget(JavaScriptDebugTarget javaScriptDebugTarget) {
        Object object;
        ArrayList arrayList = this.getRequests(javaScriptDebugTarget);
        if (arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                EventRequest eventRequest = null;
                try {
                    eventRequest = (EventRequest)object.next();
                    if (!javaScriptDebugTarget.isAvailable()) continue;
                    javaScriptDebugTarget.getEventRequestManager().deleteEventRequest(eventRequest);
                }
                finally {
                    this.deregisterRequest(javaScriptDebugTarget, eventRequest);
                }
            }
        }
        object = this.r;
        synchronized (object) {
            this.r.remove(javaScriptDebugTarget);
        }
        if (this.q == null) {
            return;
        }
        this.q.remove(javaScriptDebugTarget);
    }

    protected void handleBreakpointChange() throws CoreException {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null) {
            IDebugTarget[] iDebugTargetArray = debugPlugin.getLaunchManager().getDebugTargets();
            int n = 0;
            while (n < iDebugTargetArray.length) {
                if (iDebugTargetArray[n].getModelIdentifier().equals("org.ccdt.debug.model")) {
                    JavaScriptDebugTarget javaScriptDebugTarget = (JavaScriptDebugTarget)iDebugTargetArray[n];
                    if (javaScriptDebugTarget.canUpdateBreakpoints()) {
                        javaScriptDebugTarget.updateBreakpoint(this);
                    } else {
                        this.recreateBreakpointFor((JavaScriptDebugTarget)iDebugTargetArray[n]);
                    }
                }
                ++n;
            }
        }
    }

    public void recreateBreakpointFor(JavaScriptDebugTarget javaScriptDebugTarget) throws CoreException {
        if (javaScriptDebugTarget.isAvailable() && javaScriptDebugTarget.getBreakpoints().contains(this)) {
            this.removeFromTarget(javaScriptDebugTarget);
            this.addToTarget(javaScriptDebugTarget);
        }
    }

    public void setEnabled(boolean bl) throws CoreException {
        if (this.isEnabled() != bl) {
            this.setAttribute("org.eclipse.debug.core.enabled", bl);
            this.handleBreakpointChange();
        }
    }

    @Override
    public void setSuspendPolicy(int n) throws CoreException {
        if (this.getSuspendPolicy() != n) {
            this.setAttribute("org.ccdt.debug.core.suspend_policy", n);
            this.handleBreakpointChange();
        }
    }

    @Override
    public int getSuspendPolicy() throws CoreException {
        return this.ensureMarker().getAttribute("org.ccdt.debug.core.suspend_policy", 1);
    }

    @Override
    public boolean isInstalled() throws CoreException {
        return this.ensureMarker().getAttribute(INSTALL_COUNT, 0) > 0;
    }

    protected void incrementInstallCount() throws CoreException {
        int n = this.getInstallCount();
        this.setAttribute(INSTALL_COUNT, n + 1);
    }

    public int getInstallCount() throws CoreException {
        return this.ensureMarker().getAttribute(INSTALL_COUNT, 0);
    }

    protected void decrementInstallCount() throws CoreException {
        int n = this.getInstallCount();
        if (n > 0) {
            this.setAttribute(INSTALL_COUNT, n - 1);
        }
    }

    @Override
    public void setHitCount(int n) throws CoreException, IllegalArgumentException {
        if (n != this.getHitCount()) {
            this.setAttribute("org.ccdt.debug.core.hit_count", n);
            this.handleBreakpointChange();
        }
    }

    @Override
    public int getHitCount() throws CoreException {
        return this.ensureMarker().getAttribute("org.ccdt.debug.core.hit_count", -1);
    }

    @Override
    public String getScriptPath() throws CoreException {
        return this.ensureMarker().getAttribute("org.ccdt.debug.core.script_path", "");
    }

    @Override
    public String getTypeName() throws CoreException {
        return this.ensureMarker().getAttribute("org.ccdt.debug.core.type_name", null);
    }

    protected void registerRequest(JavaScriptDebugTarget javaScriptDebugTarget, EventRequest eventRequest) {
        this.addRequestForTarget(javaScriptDebugTarget, eventRequest);
        if (!(eventRequest instanceof ScriptLoadRequest)) {
            try {
                this.incrementInstallCount();
            }
            catch (CoreException coreException) {
                JavaScriptDebugPlugin.log(coreException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addRequestForTarget(JavaScriptDebugTarget javaScriptDebugTarget, EventRequest eventRequest) {
        ArrayList<EventRequest> arrayList = this.getRequests(javaScriptDebugTarget);
        if (arrayList == null) {
            HashMap hashMap = this.r;
            synchronized (hashMap) {
                arrayList = new ArrayList<EventRequest>(2);
                this.r.put(javaScriptDebugTarget, arrayList);
            }
        }
        arrayList.add(eventRequest);
        javaScriptDebugTarget.addJSDIEventListener(this, eventRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getRequests(JavaScriptDebugTarget javaScriptDebugTarget) {
        ArrayList arrayList = null;
        HashMap hashMap = this.r;
        synchronized (hashMap) {
            arrayList = (ArrayList)this.r.get(javaScriptDebugTarget);
        }
        return arrayList;
    }

    protected void deregisterRequest(JavaScriptDebugTarget javaScriptDebugTarget, EventRequest eventRequest) {
        javaScriptDebugTarget.removeJSDIEventListener(this, eventRequest);
        if (!(eventRequest instanceof ScriptLoadRequest)) {
            try {
                this.decrementInstallCount();
            }
            catch (CoreException coreException) {
                JavaScriptDebugPlugin.log(coreException);
            }
        }
    }

    @Override
    public boolean handleEvent(Event event, JavaScriptDebugTarget javaScriptDebugTarget, boolean bl, EventSet eventSet) {
        Object object;
        if (event instanceof BreakpointEvent && (object = javaScriptDebugTarget.findThread(((BreakpointEvent)event).thread())) != null) {
            return !((JavaScriptThread)object).suspendForBreakpoint(this, bl);
        }
        if (event instanceof ScriptLoadEvent) {
            object = (ScriptLoadEvent)event;
            ScriptReference scriptReference = object.script();
            try {
                if (JavaScriptDebugPlugin.getResolutionManager().matches(scriptReference, (IPath)new Path(this.getScriptPath()))) {
                    this.createRequest(javaScriptDebugTarget, scriptReference);
                }
            }
            catch (CoreException coreException) {
                JavaScriptDebugPlugin.log(coreException);
            }
        }
        return true;
    }

    boolean a(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        return string != null && string.equals(string2);
    }

    boolean a(IPath iPath, IPath iPath2) {
        if (iPath.segmentCount() == iPath2.segmentCount()) {
            String[] stringArray = iPath.segments();
            int n = 0;
            while (n < stringArray.length) {
                if (!stringArray[n].equals(iPath2.segment(n))) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    @Override
    public void eventSetComplete(Event event, JavaScriptDebugTarget javaScriptDebugTarget, boolean bl, EventSet eventSet) {
        JavaScriptThread javaScriptThread;
        if (event instanceof BreakpointEvent && (javaScriptThread = javaScriptDebugTarget.findThread(((BreakpointEvent)event).thread())) != null) {
            javaScriptThread.suspendForBreakpointComplete(this, bl, eventSet);
        }
    }

    @Override
    public void setJavaScriptElementHandle(String string) throws CoreException {
        this.ensureMarker().setAttribute("org.ccdt.debug.core.handle", (Object)string);
    }

    @Override
    public String getJavaScriptElementHandle() throws CoreException {
        return this.ensureMarker().getAttribute("org.ccdt.debug.core.handle", null);
    }

    static /* synthetic */ IMarker a(JavaScriptBreakpoint javaScriptBreakpoint) throws DebugException {
        return javaScriptBreakpoint.ensureMarker();
    }
}

